	function [N,new_omega_p,new_omega_s,new_A_p,new_A_s] = ...
	ClassicIIR_LP_allpara_LWD(omega_p, omega_s, A_p, A_s)
	
	% This MATLAB script is the same as ClassicIIR_LP_allpara with the 
	% exception that now the filter orders are ODD. This is required by filters
	% that are implementable as a parallel connection of two real-valued 
	% all-pass filters.
	% Regarding the code, see KEY DIFFERENCE below!
	% Tapio 20.9.2018
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 			Tapio Saramaki 2018-09-20
	%	Modified by:	
	%	Copyright:			by authors - not released for commercial use
	%	Version:			1	 
	%	Known bugs:	 
	%	Report bugs to:		tapio.saramaki@tut.fi
	
	a0=sqrt(tan(pi*omega_s/2)/tan(pi*omega_p/2));  
	a1=a0^2+sqrt(a0^4-1);
	a2=a1^2+sqrt(a1^4-1);
	a3=a2^2+sqrt(a2^4-1);
	a4=a3^2+sqrt(a3^4-1);
	J0=sqrt(sqrt((10^(A_s/10)-1))/sqrt((10^(A_p/10)-1)));
	J1=J0^2+sqrt(J0^4-1);
	J2=J1^2+sqrt(J1^4-1);
	J3=J2^2+sqrt(J2^4-1);
	J4=J3^2+sqrt(J3^4-1);
	N(1)=log10(J0)/log10(a0);
	N(2)=log10(J1)/log10(a1);
	% The orders for the the Chebyshev and inverse Chebyshev filters are the 
	% same.
	N(3)=N(2);
	N(4)=log10(2*J4)/log10(2*a4);
	% Minimun integer-valued filter orders that are larger than or equal to 
	% their decimal counterparts.
	N=ceil(N);
	%##########################################################################
	% KEY DIFFERENCE: Find the odd orders that are larger than or equal to the
	% given orders
	%##########################################################################
	for nn=1:4
	    if rem(N(nn),2)==0
	        N(nn)=N(nn)+1;
		end
	end
	%##########################################################################
	% Minimized values of omega_s, indicated by new_omega_s, and maximized 
	% values of omega_p, indicated by new_omega_p.
	new_omega_s(1)=2*atan(J0^(2/N(1))*tan(pi*omega_p/2))/pi;
	new_omega_p(1)=2*atan(tan(pi*omega_s/2)/(J0^(2/N(1))))/pi;
	new_omega_s(2)=2*atan(.5*(J1^(1/N(2))+1/(J1^(1/N(2))))*tan(pi*omega_p/2))/pi;
	new_omega_p(2)=...
	2*atan(tan(pi*omega_s/2)/(.5*(J1^(1/N(2))+1/(J1^(1/N(2))))))/pi;
	b4=(J4/(2^(N(4)-1)))^(1/N(4));
	b3=sqrt((b4+1/b4)/2);
	b2=sqrt((b3+1/b3)/2);
	b1=sqrt((b2+1/b2)/2);
	b0=sqrt((b1+1/b1)/2);
	new_omega_s(4)=2*atan(b0^2*tan(pi*omega_p/2))/pi;
	new_omega_p(4)=2*atan(tan(pi*omega_s/2)/b0^2)/pi;
	% The values for the Chebyshev and inverse Chebyshev filters are the same.
	new_omega_s(3)=new_omega_s(2);
	new_omega_p(3)=new_omega_p(2);
	% Maximized values of A_s, indicated by new_A_s, and minimized values of 
	% A_p, indicated by new_A_p.
	new_A_s(1)=10*log10(1+(10^(A_p/10)-1)*a0^(4*N(1)));
	new_A_p(1)=10*log10(1+(10^(A_s/10)-1)/a0^(4*N(1)));
	new_A_s(2)=10*log10(1+(10^(A_p/10)-1)*((a1^N(2)+1/a1^N(2))/2)^2);
	new_A_p(2)=10*log10(1+(10^(A_s/10)-1)/((a1^N(2)+1/a1^N(2))/2)^2);
	c4=2^(N(4)-1)*a4^(N(4));
	c3=sqrt((c4+1/c4)/2);
	c2=sqrt((c3+1/c3)/2);
	c1=sqrt((c2+1/c2)/2);
	c0=sqrt((c1+1/c1)/2);
	new_A_s(4)=10*log10(1+(10^(A_p/10)-1)*c0^4);
	new_A_p(4)=10*log10(1+(10^(A_s/10)-1)/c0^4);
	% The values for the Chebyshev and inverse Chebyshev filters are the same.
	new_A_s(3)=new_A_s(2);
	new_A_p(3)=new_A_p(2);
